/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.item.food;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import satisfyu.candlelight.item.food.EffectFood;

public class EffectFoodHelper {
    public static final String STORED_EFFECTS_KEY = "StoredEffects";
    public static final String FOOD_STAGE = "CustomModelData";

    public static void addEffect(ItemStack stack, Pair<MobEffectInstance, Float> effect) {
        ListTag nbtList = EffectFoodHelper.getEffectNbt(stack);
        boolean bl = true;
        int id = MobEffect.m_19459_((MobEffect)((MobEffectInstance)effect.getFirst()).m_19544_());
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            int idTemp = nbtCompound.m_128451_("id");
            if (idTemp != id) continue;
            bl = false;
            break;
        }
        if (bl) {
            nbtList.add((Object)EffectFoodHelper.createNbt((short)id, effect));
        }
        stack.m_41784_().m_128365_(STORED_EFFECTS_KEY, (Tag)nbtList);
    }

    private static ListTag getEffectNbt(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41783_();
        return nbtCompound != null ? nbtCompound.m_128437_(STORED_EFFECTS_KEY, 10) : new ListTag();
    }

    public static CompoundTag createNbt(short id, Pair<MobEffectInstance, Float> effect) {
        CompoundTag nbtCompound = new CompoundTag();
        nbtCompound.m_128376_("id", id);
        nbtCompound.m_128405_("duration", ((MobEffectInstance)effect.getFirst()).m_19557_());
        nbtCompound.m_128405_("amplifier", ((MobEffectInstance)effect.getFirst()).m_19564_());
        nbtCompound.m_128350_("chance", ((Float)effect.getSecond()).floatValue());
        return nbtCompound;
    }

    public static List<Pair<MobEffectInstance, Float>> getEffects(ItemStack stack) {
        if (stack.m_41720_() instanceof EffectFood) {
            return EffectFoodHelper.fromNbt(EffectFoodHelper.getEffectNbt(stack));
        }
        if (stack.m_41720_() instanceof PotionItem) {
            List effects = PotionUtils.m_43547_((ItemStack)stack);
            ArrayList returnEffects = Lists.newArrayList();
            for (MobEffectInstance effect : effects) {
                returnEffects.add(new Pair((Object)effect, (Object)Float.valueOf(1.0f)));
            }
            return returnEffects;
        }
        FoodProperties foodComponent = stack.m_41720_().m_41473_();
        if (foodComponent != null) {
            return foodComponent.m_38749_();
        }
        return Lists.newArrayList();
    }

    public static List<Pair<MobEffectInstance, Float>> fromNbt(ListTag list) {
        ArrayList effects = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbtCompound = list.m_128728_(i);
            MobEffect effect = MobEffect.m_19453_((int)nbtCompound.m_128448_("id"));
            assert (effect != null);
            effects.add(new Pair((Object)new MobEffectInstance(effect, nbtCompound.m_128451_("duration"), nbtCompound.m_128451_("amplifier")), (Object)Float.valueOf(nbtCompound.m_128457_("chance"))));
        }
        return effects;
    }

    public static ItemStack setStage(ItemStack stack, int stage) {
        CompoundTag nbtCompound = stack.m_41783_() != null ? stack.m_41783_() : new CompoundTag();
        nbtCompound.m_128405_(FOOD_STAGE, stage);
        stack.m_41751_(nbtCompound);
        return stack;
    }

    public static int getStage(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41783_();
        return nbtCompound != null ? nbtCompound.m_128451_(FOOD_STAGE) : 0;
    }

    public static void getTooltip(ItemStack stack, List<Component> tooltip) {
        List<Pair<MobEffectInstance, Float>> effects = EffectFoodHelper.getEffects(stack);
        if (effects.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            for (Pair<MobEffectInstance, Float> effectPair : effects) {
                MobEffectInstance statusEffect = (MobEffectInstance)effectPair.getFirst();
                MutableComponent mutableText = Component.m_237115_((String)statusEffect.m_19576_());
                if (statusEffect.m_19564_() > 0) {
                    mutableText = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutableText, Component.m_237115_((String)("potion.potency." + statusEffect.m_19564_()))});
                }
                if (((MobEffectInstance)effectPair.getFirst()).m_19557_() > 20) {
                    mutableText = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutableText, MobEffectUtil.m_19581_((MobEffectInstance)statusEffect, (float)1.0f)});
                }
                tooltip.add((Component)mutableText.m_130940_(statusEffect.m_19544_().m_19483_().m_19497_()));
            }
        }
    }
}

